#include <algorithm>
#include <cstdint>
#include <cstring>
#include <iostream>
#include <stack>
#include <tuple>
#include <unordered_map>
#include <unordered_set>
#include <vector>

typedef std::unordered_map<uint16_t, std::unordered_map<uint16_t, int16_t>> Graph;
constexpr int16_t INF = 30000;
constexpr int16_t NEG_INF = -30000;
constexpr int16_t unvisited = -1;

int main() noexcept {
  std::ios::sync_with_stdio(false);
  std::cin.tie(nullptr);
  std::cout.tie(nullptr);
  std::cerr.tie(nullptr);

	// dalja optimizacija je da nam koordinate uopste nisu 
	// ni potrebne, vec samo broj tacaka na istoj dijagonali
	// i broj parnih i neparnih koordinata tacaka za svako
	// x i y
	std::unordered_map<int32_t, std::pair<int32_t, int32_t>> xhashmap;
	std::unordered_map<int32_t, std::pair<int32_t, int32_t>> yhashmap;
	std::unordered_map<int32_t, int32_t> phashmap;
	std::unordered_map<int32_t, int32_t> nhashmap;

	uint64_t greetings = 0;
	uint32_t n, i, parni, neparni;
	int32_t x, y;
	bool inserted;

	std::cin >> n;

	for(i = 0; i < n; ++i) {
		std::cin >> x >> y;

		if (x % 2 == 0)
			yhashmap[y].first++;
		else
			yhashmap[y].second++;

		if (y % 2 == 0)
			xhashmap[x].first++;
		else
			xhashmap[x].second++;

		++phashmap[x+y];
		++nhashmap[x-y];
	}

	// ovde je trivialno prosto da se dokaze
	// da ako imamo n tacaka na dijagonali imamo
	// presekod n^2 - n za svaku odnosno n(n-1)
	for(const auto& it: phashmap)
		greetings += it.second*(it.second-1);
	for(const auto& it: nhashmap)
		greetings += it.second*(it.second-1);

	// sad na osnovu formule
	// x2 == x1 && ((y2 - y1) % 2 == 0)
	// posto znamo da je x2 == x1 jer je it.first isti
	// za svaki hashset trebamo da pretrazimo svaki
	// y za uslov
	// uslov mozemo da optimizujemo tako što kažemo da
	// razlika moze da bude parna kada:
	// neparan broj oduzmemo neparnim
	// paran broj oduzmemo parnim
	// iz kombinatorike znamo da je ovo n*(n-1)/2
	// ovo isto znaci da ne moramo da prolazimo kroz
	// svaki element za O(k^2) vec možemo da napravimo
	// dve brojaca parnih i neparnih brojeva pa iskoristimo
	// formulu za O(n)
	for(const auto& it : xhashmap) {
		parni = it.second.first;
		neparni = it.second.second;
		greetings += parni*(parni-1)/2;
		greetings += neparni*(neparni-1)/2;
	}

	for(const auto& it : yhashmap) {
		parni = it.second.first;
		neparni = it.second.second;
		greetings += parni*(parni-1)/2;
		greetings += neparni*(neparni-1)/2;
	}

	std::cout << greetings;
}